/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.install;

import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.LauncherException;
import com.skcraft.launcher.install.InstallTask;
import com.skcraft.launcher.util.FileUtils;
import java.io.File;
import java.util.logging.Logger;

public class FileVerify
implements InstallTask {
    private static final Logger log = Logger.getLogger(FileVerify.class.getName());
    private final File target;
    private final String name;
    private final String hash;

    @Override
    public void execute(Launcher launcher) throws Exception {
        log.info("Verifying file " + this.name);
        String actualHash = FileUtils.getShaHash(this.target);
        if (!actualHash.equals(this.hash)) {
            String message = String.format("File %s (%s) is corrupt (invalid hash)\nExpected '%s'\nGot '%s'", this.name, this.target.getAbsolutePath(), this.hash, actualHash);
            throw new LauncherException(message, message);
        }
    }

    @Override
    public double getProgress() {
        return -1.0;
    }

    @Override
    public String getStatus() {
        return "Verifying " + this.name;
    }

    public FileVerify(File target, String name, String hash) {
        this.target = target;
        this.name = name;
        this.hash = hash;
    }
}

