/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.auth.microsoft;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.auth.microsoft.OauthResult;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class OauthHttpHandler {
    private static final Logger log = Logger.getLogger(OauthHttpHandler.class.getName());
    private Executor executor = Executors.newCachedThreadPool();
    private HttpServer server = HttpServer.create(new InetSocketAddress("localhost", 0), 0);
    private OauthResult result;

    public OauthHttpHandler() throws IOException {
        this.server.createContext("/", new Handler());
        this.server.setExecutor(this.executor);
        this.server.start();
    }

    public int getPort() {
        return this.server.getAddress().getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OauthResult await() throws InterruptedException {
        OauthHttpHandler oauthHttpHandler = this;
        synchronized (oauthHttpHandler) {
            this.wait();
        }
        this.server.stop(3);
        return this.result;
    }

    private class Handler
    implements HttpHandler {
        private Handler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            String query = httpExchange.getRequestURI().getQuery();
            Map<String, String> qs = Splitter.on('&').withKeyValueSeparator('=').split(query);
            if (qs.get("error") != null) {
                OauthHttpHandler.this.result = new OauthResult.Error(qs.get("error_description"));
            } else {
                OauthHttpHandler.this.result = new OauthResult.Success(qs.get("code"));
            }
            OauthHttpHandler oauthHttpHandler = OauthHttpHandler.this;
            synchronized (oauthHttpHandler) {
                OauthHttpHandler.this.notifyAll();
            }
            InputStream is = Launcher.class.getResourceAsStream("login.html");
            byte[] response = is != null ? IOUtils.toByteArray(is) : "Unable to fetch resource login.html".getBytes(Charsets.UTF_8);
            httpExchange.sendResponseHeaders(200, response.length);
            httpExchange.getResponseBody().write(response);
            httpExchange.getResponseBody().flush();
            httpExchange.getResponseBody().close();
        }
    }
}

