/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.launch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.skcraft.concurrency.DefaultProgress;
import com.skcraft.concurrency.ProgressObservable;
import com.skcraft.launcher.AssetsRoot;
import com.skcraft.launcher.Configuration;
import com.skcraft.launcher.Instance;
import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.LauncherException;
import com.skcraft.launcher.LauncherUtils;
import com.skcraft.launcher.auth.Session;
import com.skcraft.launcher.install.ZipExtract;
import com.skcraft.launcher.launch.JavaProcessBuilder;
import com.skcraft.launcher.launch.MemorySettings;
import com.skcraft.launcher.launch.runtime.JavaRuntime;
import com.skcraft.launcher.launch.runtime.JavaRuntimeFinder;
import com.skcraft.launcher.model.minecraft.AssetsIndex;
import com.skcraft.launcher.model.minecraft.FeatureList;
import com.skcraft.launcher.model.minecraft.GameArgument;
import com.skcraft.launcher.model.minecraft.JavaVersion;
import com.skcraft.launcher.model.minecraft.Library;
import com.skcraft.launcher.model.minecraft.VersionManifest;
import com.skcraft.launcher.persistence.Persistence;
import com.skcraft.launcher.util.Environment;
import com.skcraft.launcher.util.Platform;
import com.skcraft.launcher.util.SharedLocale;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.function.BiPredicate;
import java.util.logging.Logger;
import lombok.NonNull;
import org.apache.commons.lang.text.StrSubstitutor;

public class Runner
implements Callable<Process>,
ProgressObservable {
    private static final Logger log = Logger.getLogger(Runner.class.getName());
    private ProgressObservable progress = new DefaultProgress(0.0, SharedLocale.tr("runner.preparing"));
    private final ObjectMapper mapper = new ObjectMapper();
    private final Launcher launcher;
    private final Instance instance;
    private final Session session;
    private final File extractDir;
    private final BiPredicate<JavaRuntime, JavaVersion> javaRuntimeMismatch;
    private Environment environment = Environment.getInstance();
    private VersionManifest versionManifest;
    private AssetsIndex assetsIndex;
    private File virtualAssetsDir;
    private Configuration config;
    private JavaProcessBuilder builder;
    private AssetsRoot assetsRoot;
    private FeatureList.Mutable featureList;

    public Runner(@NonNull Launcher launcher, @NonNull Instance instance, @NonNull Session session, @NonNull File extractDir, BiPredicate<JavaRuntime, JavaVersion> javaRuntimeMismatch) {
        if (launcher == null) {
            throw new NullPointerException("launcher is marked non-null but is null");
        }
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (extractDir == null) {
            throw new NullPointerException("extractDir is marked non-null but is null");
        }
        this.launcher = launcher;
        this.instance = instance;
        this.session = session;
        this.extractDir = extractDir;
        this.javaRuntimeMismatch = javaRuntimeMismatch;
        this.featureList = new FeatureList.Mutable();
    }

    private File getJarPath() {
        File jarPath = this.instance.getCustomJarPath();
        if (!jarPath.exists()) {
            jarPath = this.launcher.getJarPath(this.versionManifest);
        }
        return jarPath;
    }

    @Override
    public Process call() throws Exception {
        if (!this.instance.isInstalled()) {
            throw new LauncherException("Update required", SharedLocale.tr("runner.updateRequired"));
        }
        this.config = this.launcher.getConfig();
        this.builder = new JavaProcessBuilder();
        this.assetsRoot = this.launcher.getAssets();
        this.versionManifest = this.mapper.readValue(this.instance.getVersionPath(), VersionManifest.class);
        File assetsFile = this.assetsRoot.getIndexPath(this.versionManifest);
        try {
            this.assetsIndex = this.mapper.readValue(assetsFile, AssetsIndex.class);
        }
        catch (FileNotFoundException e) {
            this.instance.setInstalled(false);
            Persistence.commitAndForget(this.instance);
            throw new LauncherException("Missing assets index " + assetsFile.getAbsolutePath(), SharedLocale.tr("runner.missingAssetsIndex", this.instance.getTitle(), assetsFile.getAbsolutePath()));
        }
        catch (IOException e) {
            this.instance.setInstalled(false);
            Persistence.commitAndForget(this.instance);
            throw new LauncherException("Corrupt assets index " + assetsFile.getAbsolutePath(), SharedLocale.tr("runner.corruptAssetsIndex", this.instance.getTitle(), assetsFile.getAbsolutePath()));
        }
        try {
            AssetsRoot.AssetsTreeBuilder assetsBuilder = this.assetsRoot.createAssetsBuilder(this.versionManifest);
            this.progress = assetsBuilder;
            this.virtualAssetsDir = assetsBuilder.build();
        }
        catch (LauncherException e) {
            this.instance.setInstalled(false);
            Persistence.commitAndForget(this.instance);
            throw e;
        }
        this.progress = new DefaultProgress(0.9, SharedLocale.tr("runner.collectingArgs"));
        this.builder.setMainClass(this.versionManifest.getMainClass());
        this.addWindowArgs();
        this.addLibraries();
        this.addJvmArgs();
        this.addJarArgs();
        this.addProxyArgs();
        this.addServerArgs();
        this.addPlatformArgs();
        this.addLegacyArgs();
        this.callLaunchModifier();
        this.verifyJavaRuntime();
        ProcessBuilder processBuilder = new ProcessBuilder(this.builder.buildCommand());
        processBuilder.directory(this.instance.getContentDir());
        log.info("Launching: " + this.builder);
        LauncherUtils.checkInterrupted();
        this.progress = new DefaultProgress(1.0, SharedLocale.tr("runner.startingJava"));
        return processBuilder.start();
    }

    private void callLaunchModifier() {
        this.instance.modify(this.builder);
    }

    private void verifyJavaRuntime() {
        boolean launchAnyway;
        JavaRuntime pickedRuntime = this.builder.getRuntime();
        JavaVersion targetVersion = this.versionManifest.getJavaVersion();
        if (pickedRuntime == null || targetVersion == null) {
            return;
        }
        if (pickedRuntime.getMajorVersion() != targetVersion.getMajorVersion() && !(launchAnyway = this.javaRuntimeMismatch.test(pickedRuntime, targetVersion))) {
            throw new CancellationException("Launch cancelled by user.");
        }
    }

    private void addPlatformArgs() {
        File icnsPath;
        if (this.getEnvironment().getPlatform() == Platform.MAC_OS_X && (icnsPath = this.assetsIndex.getObjectPath(this.assetsRoot, "icons/minecraft.icns")) != null) {
            this.builder.getFlags().add("-Xdock:icon=" + icnsPath.getAbsolutePath());
            this.builder.getFlags().add("-Xdock:name=Minecraft");
        }
    }

    private void addLibraries() throws LauncherException {
        for (Library library : this.versionManifest.getLibraries()) {
            if (!library.matches(this.environment)) continue;
            File path = new File(this.launcher.getLibrariesDir(), library.getPath(this.environment));
            if (path.exists()) {
                Library.Extract extract = library.getExtract();
                if (extract != null) {
                    ZipExtract zipExtract = new ZipExtract(Files.asByteSource(path), this.extractDir);
                    zipExtract.setExclude(extract.getExclude());
                    zipExtract.run();
                    continue;
                }
                this.builder.classPath(path);
                continue;
            }
            this.instance.setInstalled(false);
            Persistence.commitAndForget(this.instance);
            throw new LauncherException("Missing library " + library.getName(), SharedLocale.tr("runner.missingLibrary", this.instance.getTitle(), library.getName()));
        }
        this.builder.classPath(this.getJarPath());
    }

    private void addJvmArgs() throws IOException, LauncherException {
        String[] rawJvmArgsList;
        Optional<MemorySettings> memorySettings = Optional.ofNullable(this.instance.getSettings().getMemorySettings());
        int minMemory = memorySettings.map(MemorySettings::getMinMemory).orElse(this.config.getMinMemory());
        int maxMemory = memorySettings.map(MemorySettings::getMaxMemory).orElse(this.config.getMaxMemory());
        int permGen = this.config.getPermGen();
        if (minMemory <= 0) {
            minMemory = 1024;
        }
        if (maxMemory <= 0) {
            maxMemory = 1024;
        }
        if (permGen <= 0) {
            permGen = 128;
        }
        if (permGen <= 64) {
            permGen = 64;
        }
        if (minMemory > maxMemory) {
            maxMemory = minMemory;
        }
        this.builder.setMinMemory(minMemory);
        this.builder.setMaxMemory(maxMemory);
        this.builder.setPermGen(permGen);
        JavaRuntime selectedRuntime = Optional.ofNullable(this.instance.getSettings().getRuntime()).orElseGet(() -> Optional.ofNullable(this.versionManifest.getJavaVersion()).flatMap(JavaRuntimeFinder::findBestJavaRuntime).orElse(this.config.getJavaRuntime()));
        this.builder.setRuntime(selectedRuntime);
        List<String> flags = this.builder.getFlags();
        for (String rawJvmArgs : rawJvmArgsList = new String[]{this.config.getJvmArgs(), this.instance.getSettings().getCustomJvmArgs()}) {
            if (Strings.isNullOrEmpty(rawJvmArgs)) continue;
            flags.addAll(JavaProcessBuilder.splitArgs(rawJvmArgs));
        }
        List<GameArgument> javaArguments = this.versionManifest.getArguments().getJvmArguments();
        StrSubstitutor substitutor = new StrSubstitutor(this.getCommandSubstitutions());
        for (GameArgument arg : javaArguments) {
            if (!arg.shouldApply(this.environment, this.featureList)) continue;
            for (String subArg : arg.getValues()) {
                flags.add(substitutor.replace(subArg));
            }
        }
        if (this.versionManifest.getLogging() != null && this.versionManifest.getLogging().getClient() != null) {
            log.info("Logging config present, log4j2 bug likely mitigated");
            VersionManifest.LoggingConfig config = this.versionManifest.getLogging().getClient();
            File configFile = new File(this.launcher.getLibrariesDir(), config.getFile().getId());
            StrSubstitutor loggingSub = new StrSubstitutor(ImmutableMap.of("path", configFile.getAbsolutePath()));
            flags.add(loggingSub.replace(config.getArgument()));
        }
    }

    private void addJarArgs() throws JsonProcessingException {
        List<String> args = this.builder.getArgs();
        List<GameArgument> rawArgs = this.versionManifest.getArguments().getGameArguments();
        StrSubstitutor substitutor = new StrSubstitutor(this.getCommandSubstitutions());
        for (GameArgument arg : rawArgs) {
            if (!arg.shouldApply(this.environment, this.featureList)) continue;
            for (String subArg : arg.getValues()) {
                args.add(substitutor.replace(subArg));
            }
        }
    }

    private void addProxyArgs() {
        List<String> args = this.builder.getArgs();
        if (this.config.isProxyEnabled()) {
            String host = this.config.getProxyHost();
            int port = this.config.getProxyPort();
            String username = this.config.getProxyUsername();
            String password = this.config.getProxyPassword();
            if (!Strings.isNullOrEmpty(host) && port > 0 && port < 65535) {
                args.add("--proxyHost");
                args.add(this.config.getProxyHost());
                args.add("--proxyPort");
                args.add(String.valueOf(port));
                if (!Strings.isNullOrEmpty(username)) {
                    this.builder.getArgs().add("--proxyUser");
                    this.builder.getArgs().add(username);
                    this.builder.getArgs().add("--proxyPass");
                    this.builder.getArgs().add(password);
                }
            }
        }
    }

    private void addServerArgs() {
        List<String> args = this.builder.getArgs();
        if (this.config.isServerEnabled()) {
            String host = this.config.getServerHost();
            int port = this.config.getServerPort();
            if (!Strings.isNullOrEmpty(host) && port > 0 && port < 65535) {
                args.add("--server");
                args.add(host);
                args.add("--port");
                args.add(String.valueOf(port));
            }
        }
    }

    private void addWindowArgs() {
        int width = this.config.getWindowWidth();
        if (width >= 10) {
            this.featureList.addFeature("has_custom_resolution", true);
        }
    }

    private void addLegacyArgs() {
        List<String> flags = this.builder.getFlags();
        if (this.versionManifest.getMinimumLauncherVersion() < 21) {
            flags.add("-Djava.library.path=" + this.extractDir.getAbsoluteFile());
            flags.add("-cp");
            flags.add(this.builder.buildClassPath());
            if (this.featureList.hasFeature("has_custom_resolution")) {
                List<String> args = this.builder.getArgs();
                args.add("--width");
                args.add(String.valueOf(this.config.getWindowWidth()));
                args.add("--height");
                args.add(String.valueOf(this.config.getWindowHeight()));
            }
            if (this.getEnvironment().getPlatform() == Platform.WINDOWS) {
                flags.add("-XX:HeapDumpPath=MojangTricksIntelDriversForPerformance_javaw.exe_minecraft.exe.heapdump");
            }
        }
        if (this.versionManifest.getMinimumLauncherVersion() < 18) {
            flags.add("-Dminecraft.applet.TargetDirectory=" + this.instance.getContentDir());
        }
    }

    private Map<String, String> getCommandSubstitutions() throws JsonProcessingException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("version_name", this.versionManifest.getId());
        map.put("version_type", this.launcher.getProperties().getProperty("launcherShortname"));
        map.put("auth_access_token", this.session.getAccessToken());
        map.put("auth_session", this.session.getSessionToken());
        map.put("auth_player_name", this.session.getName());
        map.put("auth_uuid", this.session.getUuid());
        map.put("profile_name", this.session.getName());
        map.put("user_type", this.session.getUserType().getName());
        map.put("user_properties", this.mapper.writeValueAsString(this.session.getUserProperties()));
        map.put("game_directory", this.instance.getContentDir().getAbsolutePath());
        map.put("game_assets", this.virtualAssetsDir.getAbsolutePath());
        map.put("assets_root", this.launcher.getAssets().getDir().getAbsolutePath());
        map.put("assets_index_name", this.versionManifest.getAssetId());
        map.put("resolution_width", String.valueOf(this.config.getWindowWidth()));
        map.put("resolution_height", String.valueOf(this.config.getWindowHeight()));
        map.put("launcher_name", this.launcher.getTitle());
        map.put("launcher_version", this.launcher.getVersion());
        map.put("classpath", this.builder.buildClassPath());
        map.put("natives_directory", this.extractDir.getAbsolutePath());
        map.put("library_directory", this.launcher.getLibrariesDir().getAbsolutePath());
        map.put("classpath_separator", System.getProperty("path.separator"));
        return map;
    }

    @Override
    public double getProgress() {
        return this.progress.getProgress();
    }

    @Override
    public String getStatus() {
        return this.progress.getStatus();
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

