/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.install;

import com.skcraft.concurrency.ProgressObservable;
import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.LauncherUtils;
import com.skcraft.launcher.install.Downloader;
import com.skcraft.launcher.install.HttpDownloader;
import com.skcraft.launcher.install.InstallTask;
import com.skcraft.launcher.util.SharedLocale;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import lombok.NonNull;

public class Installer
implements ProgressObservable {
    private static final Logger log = Logger.getLogger(Installer.class.getName());
    private final File tempDir;
    private final HttpDownloader downloader;
    private TaskQueue mainQueue = new TaskQueue();
    private TaskQueue lateQueue = new TaskQueue();
    private transient TaskQueue activeQueue;

    public Installer(@NonNull File tempDir) {
        if (tempDir == null) {
            throw new NullPointerException("tempDir is marked non-null but is null");
        }
        this.tempDir = tempDir;
        this.downloader = new HttpDownloader(tempDir);
    }

    public synchronized void queue(@NonNull InstallTask runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        this.mainQueue.queue(runnable);
    }

    public synchronized void queueLate(@NonNull InstallTask runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        this.lateQueue.queue(runnable);
    }

    public void download() throws IOException, InterruptedException {
        this.downloader.execute();
    }

    public synchronized void execute(Launcher launcher) throws Exception {
        this.activeQueue = this.mainQueue;
        this.mainQueue.execute(launcher);
        this.activeQueue = null;
    }

    public synchronized void executeLate(Launcher launcher) throws Exception {
        this.activeQueue = this.lateQueue;
        this.lateQueue.execute(launcher);
        this.activeQueue = null;
    }

    public Downloader getDownloader() {
        return this.downloader;
    }

    @Override
    public double getProgress() {
        if (this.activeQueue == null) {
            return 0.0;
        }
        return (double)this.activeQueue.finished / (double)this.activeQueue.count;
    }

    @Override
    public String getStatus() {
        if (this.activeQueue != null && this.activeQueue.running != null) {
            InstallTask running = this.activeQueue.running;
            String status = running.getStatus();
            if (status == null) {
                status = running.toString();
            }
            return SharedLocale.tr("installer.executing", this.activeQueue.count - this.activeQueue.finished) + "\n" + status;
        }
        return SharedLocale.tr("installer.installing");
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public static class TaskQueue {
        private List<InstallTask> queue = new ArrayList<InstallTask>();
        private int count = 0;
        private int finished = 0;
        private InstallTask running;

        public synchronized void queue(@NonNull InstallTask runnable) {
            if (runnable == null) {
                throw new NullPointerException("runnable is marked non-null but is null");
            }
            this.queue.add(runnable);
            ++this.count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void execute(Launcher launcher) throws Exception {
            this.queue = Collections.unmodifiableList(this.queue);
            try {
                for (InstallTask runnable : this.queue) {
                    LauncherUtils.checkInterrupted();
                    this.running = runnable;
                    runnable.execute(launcher);
                    ++this.finished;
                }
            }
            finally {
                this.running = null;
            }
        }
    }
}

