/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.auth;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.skcraft.launcher.auth.AuthenticationException;
import com.skcraft.launcher.auth.LoginService;
import com.skcraft.launcher.auth.SavedSession;
import com.skcraft.launcher.auth.Session;
import com.skcraft.launcher.auth.UserType;
import com.skcraft.launcher.auth.microsoft.MicrosoftWebAuthorizer;
import com.skcraft.launcher.auth.microsoft.MinecraftServicesAuthorizer;
import com.skcraft.launcher.auth.microsoft.OauthResult;
import com.skcraft.launcher.auth.microsoft.XboxTokenAuthorizer;
import com.skcraft.launcher.auth.microsoft.model.McAuthResponse;
import com.skcraft.launcher.auth.microsoft.model.McProfileResponse;
import com.skcraft.launcher.auth.microsoft.model.TokenResponse;
import com.skcraft.launcher.auth.microsoft.model.XboxAuthorization;
import com.skcraft.launcher.auth.skin.MinecraftSkinService;
import com.skcraft.launcher.util.HttpRequest;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;

public class MicrosoftLoginService
implements LoginService {
    private static final URL MS_TOKEN_URL = HttpRequest.url("https://login.live.com/oauth20_token.srf");
    private final String clientId;

    public Session login(Receiver oauthDone) throws IOException, InterruptedException, AuthenticationException {
        MicrosoftWebAuthorizer authorizer = new MicrosoftWebAuthorizer(this.clientId);
        OauthResult auth = authorizer.authorize();
        if (auth.isError()) {
            OauthResult.Error error = (OauthResult.Error)auth;
            throw new AuthenticationException(error.getErrorMessage());
        }
        TokenResponse response = this.exchangeToken(form -> {
            form.add("grant_type", "authorization_code");
            form.add("redirect_uri", authorizer.getRedirectUri());
            form.add("code", ((OauthResult.Success)auth).getAuthCode());
        });
        oauthDone.tell();
        Profile session = this.performLogin(response.getAccessToken(), null);
        session.setRefreshToken(response.getRefreshToken());
        return session;
    }

    @Override
    public Session restore(SavedSession savedSession) throws IOException, InterruptedException, AuthenticationException {
        TokenResponse response = this.exchangeToken(form -> {
            form.add("grant_type", "refresh_token");
            form.add("refresh_token", savedSession.getRefreshToken());
        });
        Profile session = this.performLogin(response.getAccessToken(), savedSession);
        session.setRefreshToken(response.getRefreshToken());
        return session;
    }

    private TokenResponse exchangeToken(Consumer<HttpRequest.Form> formConsumer) throws IOException, InterruptedException, AuthenticationException {
        HttpRequest.Form form = HttpRequest.Form.form();
        form.add("client_id", this.clientId);
        formConsumer.accept(form);
        return HttpRequest.post(MS_TOKEN_URL).bodyForm(form).execute().expectResponseCodeOr(200, req -> {
            TokenError error = req.returnContent().asJson(TokenError.class);
            return new AuthenticationException(error.errorDescription);
        }).returnContent().asJson(TokenResponse.class);
    }

    private Profile performLogin(String microsoftToken, SavedSession previous) throws IOException, InterruptedException, AuthenticationException {
        XboxAuthorization xboxAuthorization = XboxTokenAuthorizer.authorizeWithXbox(microsoftToken);
        McAuthResponse auth = MinecraftServicesAuthorizer.authorizeWithMinecraft(xboxAuthorization);
        McProfileResponse profile = MinecraftServicesAuthorizer.getUserProfile(auth);
        Profile session = new Profile(auth, profile);
        if (previous != null && previous.getAvatarImage() != null) {
            session.setAvatarImage(previous.getAvatarImage());
        } else {
            session.setAvatarImage(MinecraftSkinService.fetchSkinHead(profile));
        }
        return session;
    }

    public MicrosoftLoginService(String clientId) {
        this.clientId = clientId;
    }

    @FunctionalInterface
    public static interface Receiver {
        public void tell();
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class TokenError {
        private String error;
        private String errorDescription;

        public String getError() {
            return this.error;
        }

        public String getErrorDescription() {
            return this.errorDescription;
        }

        public void setError(String error) {
            this.error = error;
        }

        public void setErrorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TokenError)) {
                return false;
            }
            TokenError other = (TokenError)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$error = this.getError();
            String other$error = other.getError();
            if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
                return false;
            }
            String this$errorDescription = this.getErrorDescription();
            String other$errorDescription = other.getErrorDescription();
            return !(this$errorDescription == null ? other$errorDescription != null : !this$errorDescription.equals(other$errorDescription));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TokenError;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $error = this.getError();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            String $errorDescription = this.getErrorDescription();
            result = result * 59 + ($errorDescription == null ? 43 : $errorDescription.hashCode());
            return result;
        }

        public String toString() {
            return "MicrosoftLoginService.TokenError(error=" + this.getError() + ", errorDescription=" + this.getErrorDescription() + ")";
        }
    }

    public static class Profile
    implements Session {
        private final McAuthResponse auth;
        private final McProfileResponse profile;
        private final Map<String, String> userProperties = Collections.emptyMap();
        private String refreshToken;
        private byte[] avatarImage;

        @Override
        public String getUuid() {
            return this.profile.getUuid();
        }

        @Override
        public String getName() {
            return this.profile.getName();
        }

        @Override
        public String getAccessToken() {
            return this.auth.getAccessToken();
        }

        @Override
        public String getSessionToken() {
            return String.format("token:%s:%s", this.getAccessToken(), this.getUuid());
        }

        @Override
        public UserType getUserType() {
            return UserType.MICROSOFT;
        }

        @Override
        public boolean isOnline() {
            return true;
        }

        @Override
        public SavedSession toSavedSession() {
            SavedSession savedSession = new SavedSession();
            savedSession.setType(this.getUserType());
            savedSession.setUsername(this.getName());
            savedSession.setUuid(this.getUuid());
            savedSession.setAccessToken(this.getAccessToken());
            savedSession.setRefreshToken(this.getRefreshToken());
            savedSession.setAvatarImage(this.getAvatarImage());
            return savedSession;
        }

        public Profile(McAuthResponse auth, McProfileResponse profile) {
            this.auth = auth;
            this.profile = profile;
        }

        public McAuthResponse getAuth() {
            return this.auth;
        }

        public McProfileResponse getProfile() {
            return this.profile;
        }

        @Override
        public Map<String, String> getUserProperties() {
            return this.userProperties;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        @Override
        public byte[] getAvatarImage() {
            return this.avatarImage;
        }

        public void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        public void setAvatarImage(byte[] avatarImage) {
            this.avatarImage = avatarImage;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Profile)) {
                return false;
            }
            Profile other = (Profile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            McAuthResponse this$auth = this.getAuth();
            McAuthResponse other$auth = other.getAuth();
            if (this$auth == null ? other$auth != null : !((Object)this$auth).equals(other$auth)) {
                return false;
            }
            McProfileResponse this$profile = this.getProfile();
            McProfileResponse other$profile = other.getProfile();
            if (this$profile == null ? other$profile != null : !((Object)this$profile).equals(other$profile)) {
                return false;
            }
            Map<String, String> this$userProperties = this.getUserProperties();
            Map<String, String> other$userProperties = other.getUserProperties();
            if (this$userProperties == null ? other$userProperties != null : !((Object)this$userProperties).equals(other$userProperties)) {
                return false;
            }
            String this$refreshToken = this.getRefreshToken();
            String other$refreshToken = other.getRefreshToken();
            if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
                return false;
            }
            return Arrays.equals(this.getAvatarImage(), other.getAvatarImage());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Profile;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            McAuthResponse $auth = this.getAuth();
            result = result * 59 + ($auth == null ? 43 : ((Object)$auth).hashCode());
            McProfileResponse $profile = this.getProfile();
            result = result * 59 + ($profile == null ? 43 : ((Object)$profile).hashCode());
            Map<String, String> $userProperties = this.getUserProperties();
            result = result * 59 + ($userProperties == null ? 43 : ((Object)$userProperties).hashCode());
            String $refreshToken = this.getRefreshToken();
            result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
            result = result * 59 + Arrays.hashCode(this.getAvatarImage());
            return result;
        }

        public String toString() {
            return "MicrosoftLoginService.Profile(auth=" + this.getAuth() + ", profile=" + this.getProfile() + ", userProperties=" + this.getUserProperties() + ", refreshToken=" + this.getRefreshToken() + ", avatarImage=" + Arrays.toString(this.getAvatarImage()) + ")";
        }
    }
}

